#ifndef WPGRAPHICSVIEW_H
#define WPGRAPHICSVIEW_H

#include <QGraphicsView>
#include <QGraphicsWidget>
#include <QGraphicsScene>

/**
 * A QGraphicsView that just displays a single QGraphicsWidget
 */
class WPGraphicsView : public QGraphicsView
{
public:    
    /** Init */
    WPGraphicsView (QWidget *parent);

    /** Add item to scene. No defined position or anything */
    void addItem (QGraphicsItem *item);

    /** Widget to display. Also adds it to the scene */
    void setWidget (QGraphicsWidget *widget);

protected:
    /** Always show our widget in full view */
    void resizeEvent (QResizeEvent *event);
    
    /** QGraphicsItem management */
    QGraphicsScene *iScene;

    /** The widget we are displaying */
    QGraphicsWidget *iWidget;
};

#endif
