#ifndef WPEXPANDINGTABWIDGET_H
#define WPEXPANDINGTABWIDGET_H

#include <QTabWidget>

/**
 * Subclass QTabWidget to have the tabs expand to take up the full available space
 *
 * XXX: except it doesn't work
 */
class WPExpandingTabWidget : public QTabWidget
{
public:
    WPExpandingTabWidget (QWidget *parent = NULL)
      : QTabWidget(parent)
      , resizing(false)
    {
        // XXX: doesn't work?
        tabBar()->setExpanding(true);
    }

protected:    
/* http://stackoverflow.com/questions/2480773/qt-styling-qtabwidget
 * XXX: ...but it does an infinite loop */   
    void resizeEvent (QResizeEvent *e)
    {
    if(!resizing)
        {
        resizing = true;

    #if defined(Q_OS_SYMBIAN)
        const int tabBorderWidth = 1;
        const int edgeMargin = 3;
    #elif defined(Q_WS_MAEMO_5)
        const int tabBorderWidth = 2;
        const int edgeMargin = 7;
    #else
        const int tabBorderWidth = 2;
        const int edgeMargin = 7;
    #endif

        QString style;
        style += QString("QTabBar { padding: 0; }\n");
        style += QString("QTabBar::tab { border-width: %1px; }\n").arg(tabBorderWidth);

        // recalc tab widths
        if (tabPosition() == QTabWidget::North || tabPosition() == QTabWidget::South) {
            if(tabPosition() == QTabWidget::North) {
				style += QString("QTabBar::tab { border-bottom: none; }\n");
            } else {
				style += QString("QTabBar::tab { border-top: none; }\n");
            }
            style += QString("QTabBar::tab { padding-left: 0; "
                                            "padding-right: 0; "
                                            "margin-left: 0; "
                                            "margin-right: 0; }\n");

            float width = size().width();
            width -= 2 * edgeMargin;
            width -= count() * 2 * tabBorderWidth;
            width /= count();

            style += QString("QTabBar::tab:first { margin-left: %1px; }\n").arg(edgeMargin);
            style += QString("QTabBar::tab:last { margin-right: %1px; }\n").arg(edgeMargin);
            style += QString("QTabBar::tab { width: %1px; } ").arg(int(width));
        } else {
            if(tabPosition() == QTabWidget::East) {
                    style += QString("QTabBar::tab { border-left: none; }\n");
            } else {
                    style += QString("QTabBar::tab { border-right: none; }\n");
            }

            style += QString("QTabBar::tab { padding-top: 0; "
                                            "padding-bottom: 0; "
                                            "margin-top: 0; "
                                            "margin-bottom: 0; }\n");

            float height = size().height();
            height -= 2 * edgeMargin;
            height -= count() * 2 * tabBorderWidth;
            height /= count();

            /* :first is at top! */
            style += QString("QTabBar::tab:first { margin-top: %1px; }\n").arg(edgeMargin);
            style += QString("QTabBar::tab:last { margin-bottom: %1px; }\n").arg(edgeMargin);
            style += QString("QTabBar::tab { height: %1px; } ").arg(int(height));
        }

        // apply, before resize
        setStyleSheet(style);
        QTabWidget::resizeEvent(e);

        resizing = false;
        }
    else
        {
        QTabWidget::resizeEvent(e);
        }
    }
    
    bool resizing;
};

#endif /* WPEXPANDINGTABWIDGET_H */
