#ifndef WPCONFIRMDIALOG_H
#define WPCONFIRMDIALOG_H

#include <QtGui/QDialog>
#include <QDesktopWidget>

#include "ui_wpconfirmdialog.h"

/* Utility macro for most common use case:
 * return from function if user selects "no" from dialog
 * Also works around some Qt bugs in symbian
 */
#define WP_CONFIRM_AND_RETURN_ON_FALSE(parent) if(!WPConfirmDialog::RunDialog(parent)) { return; }

class WPConfirmDialog : public QDialog
{
    Q_OBJECT

public:
    static inline bool RunDialog(QWidget *parent) {
        WPConfirmDialog dlg(parent);
        QSize size;
        QPoint pos;
        if (parent) {
            size = parent->size();
            pos = parent->pos();
        } else
            size = QApplication::desktop()->size();
        int x = (size.width() - dlg.width()) / 2;
        int y = (size.height() - dlg.height()) / 2;
        dlg.move(pos.x() + x, pos.y() + y);
        return dlg.ConfirmUser();
    }
    
public:
    WPConfirmDialog(QWidget *parent = 0);
    ~WPConfirmDialog();

    bool ConfirmUser();
    
    void keyPressEvent(QKeyEvent * event );

private slots:
    void yesClicked();
    void noClicked();

private:
    Ui::WPConfirmDialogClass ui;
    bool iResponse;
    
    QAction * iYesAction;
    QAction * iNoAction;
};

#endif // WPCONFIRMDIALOG_H
