#ifndef WPBLOGGRAPHICSLIST_H_
#define WPBLOGGRAPHICSLIST_H_

#include "wpgraphicslist.h"
#include "WPData.h"

class WPBlogGraphicsListItem;
class ButtonGraphicsProxy;
class QGraphicsProxyWidget;
class BlogView;

class WPBlogGraphicsList : public WPGraphicsList
{
    Q_OBJECT

public:
    WPBlogGraphicsList(BlogView* aBlogView, const QGraphicsView& aGraphicsView,
        PannableView* aPannableView);
    ~WPBlogGraphicsList();

public slots:
    void UpdateData(const WPDataUsersBlogs& aUsersBlogs);
    
private:
    void AddBlog(const WPDataBlog& aBlog);
    QString const CurrentBlogId();
    
private: // WPGraphicsList implementation
    void PopulatePopupMenuForCurrentItem(PopupMenu* aPopupMenu);
    bool IsFocusable(QGraphicsLayoutItem * item);
    
private slots:
    void AddNewBlog();
    void Open();
    void Edit();
    void Delete();
    void DeferredRemoveBlogFromLayout();
    
private:
    // Ugly workarounds because QObject does not support templates...
    /*WPBlogGraphicsListItem * ItemAt(int i) 
    	{ return reinterpret_cast<WPBlogGraphicsListItem *> (iItems[i]); }*/
    WPBlogGraphicsListItem * CurrentItem()
        { return reinterpret_cast<WPBlogGraphicsListItem *> (CurrentListItem()); }

private: // Data

    BlogView* iBlogView;
    QString  iTitle;
    QAction* iActionOpen;
    QAction* iActionEdit;
    QAction* iActionDelete;
    
    ButtonGraphicsProxy* iNewBlogButton;
    
    QGraphicsLinearLayout * iListLayout;
    
    QGraphicsLayoutItem * iDeferredRemoveLayoutItem;
};


#endif /* WPBLOGGRAPHICSLIST_H_ */
