/*
 * themedatastorage.cpp
 *
 *  Created on: 27.5.2010
 *      Author: jlep
 */

#include <QFont>
#include <QPixmap>
#include <QLinearGradient>

#ifdef HAVE_QTMOBILITY
#include <QSystemInfo>
#endif // HAVE_QTMOBILITY

#include "wpcommongeometry.h"
#include "themedatastorage.h"
#include "utils.h"

#include "ScopedTimer.h"

ThemeData::ThemeData() :
      iTabGradientBrush(NULL),
      iTabFont(NULL),
      iListContentFont(NULL),
      iListInfoFont(NULL)
{
    iIcons.clear();
}

ThemeData::~ThemeData()
{
    delete iTabGradientBrush;
    delete iTabFont;
    
    delete iListContentFont;
    delete iListInfoFont;

    iIcons.clear();
}

void ThemeData::Init()
{
    TIME_FUNCTION_ALWAYS
    
    // Tabs
    iTabBarHeight = Utils::smallScreen() ? 27 : 60;
    iMinTabSize = Utils::smallScreen() ? QSizeF(20, 10) :
                                         QSizeF(80, 55); 
    QLinearGradient ql(0, 0, 0, iTabBarHeight);
    ql.setColorAt(0.0, QColor(238,238,238));
    ql.setColorAt(0.5, QColor(216,216,216));
    ql.setColorAt(1.0, QColor(203,203,203));
    iTabGradientBrush = new QBrush(ql);
    iTabFont = new QFont("Arial");
    iTabFont->setPixelSize(Utils::smallScreen() ? 12 : 10);    
    
    iIconSheet = QPixmap(":/images/icons32-vs.png");
    iBwIconSheet = QPixmap(":/images/icons32-vs-bw.png");
    
    // Lists
	
    iListContentFont = new QFont("Arial");
    iListContentFont->setPixelSize(Utils::smallScreen() ? 14 : 19);
	
	iListInfoFont = new QFont("Arial");
	iListInfoFont->setPixelSize(Utils::smallScreen() ? 11 : 14);
	
	iListItemInternalPadding = Utils::smallScreen() ? 3 : 5;
	iListItemContentVMargin = Utils::smallScreen() ? 6 : 9;
    iListItemContentHMargin = Utils::smallScreen() ? 8 : 14;
	
	iListShowCommentIcons = !Utils::smallScreen();
	
    #ifdef Q_WS_MAEMO_5
    iListTitleMargin = 8;
	iListTitleHeight = 26;
    #else
    iListTitleMargin = 2;
	iListTitleHeight = Utils::smallScreen() ? 18 : 26;
    #endif 
	
    // XXX: never used
	// iListItemSpacing = Utils::smallScreen() ? 3 : 5;
	
	iListButtonQss =
                "QPushButton {"
                     // XXX: broken, background overflows borders: 
					 // "margin: 0 9px;" 
					 "border: none;"
                "}";
}

bool ThemeData::AnimateMenus() const
{
    static bool const animate = 
#if defined(Q_WS_MAEMO_5)
        false; 
#elif defined(Q_OS_SYMBIAN)
        AnimateMenusSymbian();
#else
        true;
#endif
    
    return animate;
}

QPixmap const & ThemeData::GetIcon(QPixmap const & source, IconMap & map, TIconSheet icon)
{
    // Lazy initialization for icons, don't do any extra work
    if(!map.contains(icon)) {
        const int iconCount = 12;
        const int iconWidth = source.width() / iconCount;
        map[icon] = source.copy(icon * iconWidth, 0, iconWidth, source.height());
    }
    
    return map[icon];
}

QPixmap const & ThemeData::GetContextIcon(TContextIconSheet icon)
{
    if(!iContextIcons.contains(icon)) {
        QPixmap pixmap;
        switch(icon) {
            case EApprove:
                pixmap.load(":/images/approve.png");
                break;
            case EEdit:
                pixmap.load(":/images/edit.png");
                break;
            case EOpen:
                pixmap.load(":/images/open.png");
                break;
            case ERemove:
                pixmap.load(":/images/remove.png");
                break;
            case EReply:
                pixmap.load(":/images/reply.png");
                break;
            case ESpam:
                pixmap.load(":/images/spam.png");
                break;
            case EView:
                pixmap.load(":/images/view.png");
                break;
        }
        iContextIcons[icon] = pixmap;
    }
    
    return iContextIcons[icon];
}

bool ThemeData::AnimateMenusSymbian()
{
#ifdef HAVE_QTMOBILITY
    // N8 Does not like animations ATM,
    // so we disable animations for Symbian^3 (== 5.2)
    using QtMobility::QSystemInfo;
    QSystemInfo sysInfo;
    return sysInfo.version(QSystemInfo::Os) != QString("5.2");
#else
    return false; // Just to be sure
#endif
}
