/*
 * statsweeklydata.h
 *
 *  Created on: 22.3.2010
 *      Author: aahv
 */

#ifndef STATSWEEKLYDATA_H
#define STATSWEEKLYDATA_H

#include "lineplotdata.h"

#include <QMap>
#include <QDate>

class StatsWeeklyData : public LinePlotData
{
public:
    StatsWeeklyData();
    ~StatsWeeklyData();

    int getDataCount() const;

    int getMinValue() const;
    int getMaxValue() const;
    int getValue(int index) const;

    QVariant getData(int index) const;

    void reload(const QMap<QDate, int>& data, QDate from = QDate::currentDate().addDays(-70), QDate to = QDate::currentDate());
private:
    QMap<QDate, int> data;

    int maxValue;
    int minValue;
};

#endif // STATSWEEKLYDATA_H
