/*
 * statsvisits.h
 *
 *  Created on: 19.3.2010
 *      Author: aahv
 */

#ifndef STATSVISITS_H
#define STATSVISITS_H

#include <QWidget>
#include <QStandardItemModel>
#include <QAbstractButton>

#include "WPData.h"
#include "lineplot.h"
#include "lineplotdata.h"
#include "statsdailydata.h"
#include "statsweeklydata.h"
#include "statsmonthlydata.h"

class QButtonGroup;
class QGridLayout;
class QLabel;

class StatsVisits : public QWidget {
    Q_OBJECT
public:
    StatsVisits(QWidget *parent = 0);
    ~StatsVisits();

public slots:
    void updateStats(const WPDataStats& stats);

private slots:
    void buttonClicked(int id);

protected:
    void resizeEvent(QResizeEvent *);

private:
    void updateLayout();
    void switchPlotData(LinePlotData* data);

private:
    QLabel* label;
    QAbstractButton *dayButton;
    QAbstractButton *weekButton;
    QAbstractButton *monthButton;
    QButtonGroup *viewButtonGroup;
    LinePlot* plot;

    StatsDailyData* dailyData;
    StatsWeeklyData* weeklyData;
    StatsMonthlyData* monthlyData;

};

#endif // STATSVISITS_H
