/*
 * statslistview.h
 *
 *  Created on: 19.3.2010
 *      Author: aahv
 */

#ifndef STATSLISTVIEW_H
#define STATSLISTVIEW_H

#include <QWidget>
#include <QStandardItemModel>

#include "WPData.h"

namespace Ui {
    class StatsListView;
}

enum ListView {
    Referrers,
    Searches
};

bool compareListItems(const QPair<QString, int>& i1, const QPair<QString, int>& i2);

class StatsListView : public QWidget {
    Q_OBJECT
public:
    StatsListView(QWidget *parent = 0);
    ~StatsListView();

    void setListView(ListView view);

public slots:
    void updateStats(const WPDataStats& stats);
    void setFocus();

protected:
    void changeEvent(QEvent *e);

    QString getTitle();
    QString getItemTitle();

private:
    Ui::StatsListView *ui;
    ListView view;

    QString content;
    QString sumContent;

private slots:
    void on_sumButton_toggled(bool checked);
};

#endif // STATSVISITS_H
