/*
 * statslistview.cpp
 *
 *  Created on: 19.3.2010
 *      Author: aahv
 */

#include "statslistview.h"
#include "ui_statslistview.h"

#include <QList>
#include <QPair>
#include <QDate>
#include <QMap>
#include <QPushButton>

StatsListView::StatsListView(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::StatsListView)
{
    ui->setupUi(this);

    ui->gridLayout->itemAtPosition(0, 1)->setAlignment(Qt::AlignTop);

    content.reserve(8192);
    sumContent.reserve(8192);

    view = Referrers;
}

StatsListView::~StatsListView()
{
    delete ui;
}

void StatsListView::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void StatsListView::setListView(ListView view) {
    this->view = view;

    ui->label->setText(getTitle().arg(QDate::currentDate().toString(Qt::ISODate)));
}

QString StatsListView::getTitle() {
    switch (view) {
    case Referrers:
        return tr("Referrers for 7 days ending %1");
    case Searches:
        return tr("Search terms for 7 days ending %1");
    }

    return QString();
}

QString StatsListView::getItemTitle() {
    switch (view) {
    case Referrers:
        return tr("Referrer");
    case Searches:
        return tr("Search term");
    }

    return QString();
}

bool compareListItems(const QPair<QString, int>& i1, const QPair<QString, int>& i2) {
    return i1.second > i2.second;
}

void StatsListView::updateStats(const WPDataStats &stats) {
    content.clear();

    QMap<QString, int> summary;

    QString itemColor;
    QDate date = QDate::currentDate();
    for (int i = 0; i < 7; ++i) {
        QString dayLabel;
        if (i == 0)
            dayLabel = tr("Today");
        else if (i == 1)
            dayLabel = tr("Yesterday");
        else
            dayLabel = date.toString(Qt::ISODate);

        content += "<h3>" + dayLabel + "</h3>";
        content += "<table width=\"100%\" cellpadding=\"2\">";
        content += "<tr><th align=\"left\">" + getItemTitle() + "</th><th align=\"right\">" + tr("Visits") + "</th></tr>";
        QList< QPair<QString, int> > items;

        switch (view) {
        case Referrers:
            items = stats.iReferrers[date];
            itemColor = "#21759b";
            break;

        case Searches:
            items = stats.iSearchTerms[date];
            itemColor = "black";
            break;
        }

        QPair<QString, int> item;
        int count = 0;
        foreach (item, items) {
            QString rowColor = ((count++) % 2 == 0? "#dcdcdc": "#fff");

            summary.insert(item.first, summary[item.first] + item.second);

            content += "<tr style=\"background-color: " + rowColor + ";\">";
            content += "<td style=\"color: " + itemColor + ";\" width=\"90%\">" + item.first + "</td><td align=\"right\">" + QString::number(item.second) + "</td>";
            content += "</tr>";
        }
        content += "</table>";

        date = date.addDays(-1);
    }

    QList< QPair<QString, int> > summaryList;
    QMap<QString, int>::const_iterator it = summary.constBegin();
    while (it != summary.constEnd()) {
        summaryList << QPair<QString, int>(it.key(), it.value());
        it++;
    }
    qSort(summaryList.begin(), summaryList.end(), compareListItems);

    QDate dateWeekAgo = QDate::currentDate().addDays(-7);
    sumContent = QString("<h3>%1 to Today</h3>").arg(dateWeekAgo.toString(Qt::ISODate));
    sumContent += "<table width=\"100%\" cellpadding=\"2\">";
    sumContent += "<tr><th align=\"left\">" + getItemTitle() + "</th><th align=\"right\">" + tr("Visits") + "</th></tr>";
    QPair<QString, int> item;
    int count = 0;
    foreach (item, summaryList) {
        QString rowColor = ((count++) % 2 == 0? "#dcdcdc": "#fff");

        sumContent += "<tr style=\"background-color: " + rowColor + ";\">";
        sumContent += "<td style=\"color: " + itemColor + ";\" width=\"90%\">" + item.first + "</td><td align=\"right\">" + QString::number(item.second) + "</td>";
        sumContent += "</tr>";
    }
    sumContent += "</table>";

    ui->text->setHtml((ui->sumButton->isChecked()? sumContent: content));
}

void StatsListView::on_sumButton_toggled(bool checked)
{
    ui->text->setHtml((checked? sumContent: content));
}

void StatsListView::setFocus()
{
    ui->label->setFocus();
}
