/*
 * statsdailydata.h
 *
 *  Created on: 22.3.2010
 *      Author: aahv
 */

#ifndef STATSDAILYDATA_H
#define STATSDAILYDATA_H

#include "lineplotdata.h"

#include <QMap>
#include <QDate>

class StatsDailyData : public LinePlotData
{
public:
    StatsDailyData();
    ~StatsDailyData();

    int getDataCount() const;

    int getMinValue() const;
    int getMaxValue() const;
    int getValue(int index) const;

    QVariant getData(int index) const;

    void reload(const QMap<QDate, int>& data, QDate from = QDate::currentDate().addDays(-29), QDate to = QDate::currentDate());
private:
    QMap<QDate, int> data;

    int maxValue;
    int minValue;

};

#endif // STATSDAILYDATA_H
