/*
 * statisticsview.cpp
 *
 *  Created on: 15.3.2010
 *      Author: aahv
 */

#include "statisticsview.h"
#include "ui_statisticsview.h"

#include <QList>
#include <QPair>
#include <QDate>
#include <QMap>
#include <QPushButton>

StatisticsView::StatisticsView(BlogView *parent) :
        QFrame(parent),
        ui(new Ui::StatisticsView), iParent(parent),
        iCloseAction(new QAction(tr("Close"), this))
{
    ui->setupUi(this);

    ui->referrers->setListView(Referrers);
    ui->searches->setListView(Searches);

    ui->tabWidget->setTabText(0, tr("Visits"));
    ui->tabWidget->setTabText(1, tr("Referrers"));
    ui->tabWidget->setTabText(2, tr("Searches"));

    connect(iCloseAction, SIGNAL(triggered()), iParent, SLOT(ShowTabbedListView()));
	iCloseAction->setSoftKeyRole(QAction::NegativeSoftKey);
}

StatisticsView::~StatisticsView()
{
    delete ui;
}

void StatisticsView::focusInEvent(QFocusEvent* event) {
    QFrame::focusInEvent(event);
#ifdef Q_OS_SYMBIAN
    if (ui->tabWidget->isVisible()) {
	switch(ui->tabWidget->currentIndex()) {
        case 0:
            ui->visits->setFocus();
            break;
        case 1:
            ui->referrers->setFocus();
            break;
        case 2:
            ui->searches->setFocus();
            break;
	}
    }
#endif
}

void StatisticsView::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void StatisticsView::updateStats(const WPDataStats &stats) {
    if (stats.iLastUpdated == QDate::currentDate()) {
        ui->visits->updateStats(stats);
        ui->referrers->updateStats(stats);
        ui->searches->updateStats(stats);
    }
    ui->tabWidget->setVisible(true);
}

