TEMPLATE = app
TARGET = WordPress
VERSION = 0.8.5
QT += core \
    gui \
    network \
    xml \
    svg
HEADERS += utils.h \
    addlinkdialog.h \
    enume/pannableview.h \
    enume/pannableview_p.h \
    wpcommentgraphicslist.h \
    wpcommentgraphicslistitem.h \
    wplabel.h \
    wptextbrowser.h \
    ImageThumbnailThread.h \
    richtextedit.h \
    wpscrollarea.h \
    explanatorytextedit.h \
    explanatorylineedit.h \
    CheckableListItem.h \
    clippinglabel.h \
    ErrorDialog.h \
    DialogController.h \
    MediaSearchThread.h \
    CategoryView.h \
    ProgressDialog.h \
    BlogSetupView.h \
    AddComment.h \
    SinglePostData.h \
    MDragWidget.h \
    MediaSelectionList.h \
    SinglePostView.h \
    PopupMenu.h \
    wpcommentlist.h \
    wpcommentlistitem.h \
    md5.h \
    WPXmlRsdParser.h \
    WPData.h \
    WPDataItem.cpp \
    BlogView.h \
    setupblog.h \
    addpostview.h \
    WPNetworkEngine.h \
    writepageview.h \
    WPXmlStatsParser.h \
    statisticsview.h \
    statsvisits.h \
    statslistview.h \
    lineplot.h \
    statsdailydata.h \
    lineplotdata.h \
    statsmonthlydata.h \
    statsweeklydata.h \
    busyindicator.h \
    WPXmlRequest.h \
    WPXmlResponse.h \
    wptabbargraphicswidget.h \
    wppagegraphicslist.h \
    wppagegraphicslistitem.h \
    wppostgraphicslist.h \
    wppostgraphicslistitem.h \
    wpstackedgraphicswidget.h \
    themedatastorage.h \
    wpcommongeometry.h \
    wpcustomviewbasicdata.h \
    wpconfirmdialog.h \
    version.h \
    wpgraphicslistitem.h \
    wpgraphicslist.h \
    wpbloggraphicslist.h \
    wpbloggraphicslistitem.h \
    wpexpandingtabwidget.h \
    ScopedTimer.h \
    wptitlebar.h \
    wpmenubar.h \
    wptabbedlistview.h \
    wpgraphicsview.h \
    wpmsghandler.h \
    scopedtracer.h \
    WPDataCustomField.h \
    wpcustomgraphicsitemtypes.h \
    graphicslayoutiterator.h \
    buttongraphicsproxy.h \
    inputdialog.h \
    LocationFinder.h \
    LocationButton.h \
    HtmlPainter.h \
    WpMediaFile.h \
    ShadowGraphicsItem.h \
    ListTitle.h \
    LazyInitPointer.h \
    SplashScreen.h \
    UiData.h \
    WPXmlApiKeyParser.h
SOURCES += addlinkdialog.cpp \
    enume/pannableview.cpp \
    wpcommentgraphicslist.cpp \
    wpcommentgraphicslistitem.cpp \
    wplabel.cpp \
    wptextbrowser.cpp \
    ImageThumbnailThread.cpp \
    richtextedit.cpp \
    wpscrollarea.cpp \
    explanatorytextedit.cpp \
    explanatorylineedit.cpp \
    CheckableListItem.cpp \
    clippinglabel.cpp \
    ErrorDialog.cpp \
    DialogController.cpp \
    MediaSearchThread.cpp \
    CategoryView.cpp \
    ProgressDialog.cpp \
    BlogSetupView.cpp \
    AddComment.cpp \
    SinglePostData.cpp \
    SinglePostView.cpp \
    MediaSelectionList.cpp \
    PopupMenu.cpp \
    wpcommentlist.cpp \
    md5.cpp \
    wpcommentlistitem.cpp \
    WPXmlRsdParser.cpp \
    WPData.cpp \
    WPDataGravatars.cpp \
    WPDataPage.cpp \
    WPDataPost.cpp \
    WPDataComment.cpp \
    BlogView.cpp \
    setupblog.cpp \
    addpostview.cpp \
    WPNetworkEngine.cpp \
    writepageview.cpp \
    main.cpp \
    WPXmlStatsParser.cpp \
    statisticsview.cpp \
    statsvisits.cpp \
    statslistview.cpp \
    lineplot.cpp \
    statsdailydata.cpp \
    lineplotdata.cpp \
    statsmonthlydata.cpp \
    statsweeklydata.cpp \
    busyindicator.cpp \
    WPXmlRequest.cpp \
    WPXmlResponse.cpp \
    wptabbargraphicswidget.cpp \
    wppagegraphicslist.cpp \
    wppagegraphicslistitem.cpp \
    wppostgraphicslist.cpp \
    wppostgraphicslistitem.cpp \
    wpstackedgraphicswidget.cpp \
    wpconfirmdialog.cpp \
    themedatastorage.cpp \
    wpgraphicslistitem.cpp \
    wpgraphicslist.cpp \
    wpbloggraphicslist.cpp \
    wpbloggraphicslistitem.cpp \
    wptitlebar.cpp \
    wpmenubar.cpp \
    wptabbedlistview.cpp \
    wpgraphicsview.cpp \
    wpmsghandler.cpp \
    scopedtracer.cpp \
    WPDataCustomField.cpp \
    graphicslayoutiterator.cpp \
    inputdialog.cpp \
    LocationFinder.cpp \
    LocationButton.cpp \
    HtmlPainter.cpp \
    utils.cpp \
    WpMediaFile.cpp \
    ListTitle.cpp \
    ShadowGraphicsItem.cpp \
    UiData.cpp \
    WPXmlApiKeyParser.cpp
FORMS += addlinkdialog.ui \
    richtextedit.ui \
    AddComment.ui \
    wpcommentlistitem.ui \
    writepageview.ui \
    setupblog.ui \
    addpostview.ui \
    SinglePostData.ui \
    ProgressDialog.ui \
    ErrorDialog.ui \
    CheckableListItem.ui \
    statisticsview.ui \
    statslistview.ui \
    wpconfirmdialog.ui \
    inputdialog.ui
RESOURCES += images.qrc \
    stylesheet.qrc
OTHER_FILES += qss/maemo.qss \
    qss/symbian.qss \
    qss/symbian_3.qss \
    qss/common.qss

# version numbers (does not work at least on 3.2 symbian sdk)
# DEFINES += WP_VERSION=\"$$VERSION\" WP_USERAGENT=\"wp-nokia/$$VERSION\"
# profiling
gprof { 
    QMAKE_CXXFLAGS_DEBUG += -pg
    QMAKE_LFLAGS_DEBUG += -pg
}

# "real" mobile platforms
symbian|maemo5 { 

	# Use this to enable/disable loaction
        DEFINES += HAVE_QTM_LOCATION

    CONFIG += mobility
    DEFINES += HAVE_QTMOBILITY
    MOBILITY = systeminfo bearer

	qtAddLibrary(QtSystemInfo)
	qtAddLibrary(QtBearer)

    contains( DEFINES, HAVE_QTM_LOCATION ) {
    	MOBILITY += location
    	qtAddLibrary(QtLocation)
    }
}

symbian: {
    TARGET.EPOCHEAPSIZE = 10000000 30000000

    ICON = images/wp-logo.svg
    TARGET.UID3 = 0xE0007242 # for test use, self signing
    #TARGET.UID3 = 0x20035A6C

    contains( DEFINES, HAVE_QTM_LOCATION ) {
        TARGET.CAPABILITY = "NetworkServices ReadUserData WriteUserData Location"
    } else {
    	TARGET.CAPABILITY = "NetworkServices ReadUserData WriteUserData"
    }
    
    HEADERS += sym_iap_util.h

    INCLUDEPATH += middleware
    LIBS += -lesock \
        -lcommdb \
        -linsock \
        -lefsrv \
        -leikcore \
        -leikcoctl \
        -lavkon \
        -lcone # For IAP selection
    
    # Embed qt mobility
    #qt_mobility_sis.pkg_postrules = "@\"../../third_party/qt-mobility-symbian-opensource-1.0.2/QtMobility_Express_Signed.sis\",(0x2002AC89)"
    #DEPLOYMENT += qt_mobility_sis
}

# Linux platforms (primarily for maemo, but also general linux)
unix:!symbian { 
    # the linux-g++-maemo mkspec already does this, assuming that we use it
    # compile release builds with debug syms
    # we strip this out into *-dbg
    # QMAKE_CXXFLAGS_RELEASE += -g
    # CONFIG += nostrip
    # place output files in /bin
    DESTDIR = ../bin
    
    # compile inside /build
    OBJECTS_DIR = ../build/obj
    MOC_DIR = ../build/moc
    UI_DIR = ../build/ui
    RCC_DIR = ../build/res
    
    # default prefix
    isEmpty(PREFIX):PREFIX = /usr/local
    
    # install path
    BINDIR = $$PREFIX/bin
    DATADIR = $$PREFIX/share
    DEFINES += DATADIR=\\\"$$DATADIR\\\" \
        PKGDATADIR=\\\"$$PKGDATADIR\\\"
    
    # make install
    INSTALLS += target \
        desktop \
        iconxpm \
        icon26 \
        icon48 \
        icon64
    
    # Maemo-specifics
    maemo5 { 
        # Used for "Expose" button
        QT += dbus
        
        # Application shortcut
        desktop.path = $$DATADIR/applications/hildon
        desktop.files += $${TARGET}.desktop
    }
    target.path = $$BINDIR
    iconxpm.path = $$DATADIR/pixmaps
    iconxpm.files += images/$${TARGET}.xpm
    icon26.path = $$DATADIR/icons/hicolor/26x26/apps
    icon26.files += images/26/$${TARGET}.png
    icon48.path = $$DATADIR/icons/hicolor/48x48/apps
    icon48.files += images/48/$${TARGET}.png
    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files += images/64/$${TARGET}.png
}
