#include "scopedtracer.h"

int ScopedTracer::indentCount = 0;

ScopedTracer::ScopedTracer(QString text)
    : text(text)
{
    outputIndented(QString("==> ") + text);
    indentCount++;
}

ScopedTracer::~ScopedTracer()
{
    indentCount--;
    outputIndented(QString("<== ") + text);
}
    
ScopedTracer::operator QDebug ()
{
    return outputIndented(text + ":");
}

QDebug ScopedTracer::outputIndented(QString content)
{
    QString output;
    for(int i = indentCount; i > 0; --i) {
        output += "    ";
    }
    output += content;
    return qDebug() << output.toAscii().constData(); // Avoid quotes
}
