/*
 * richtextedit.h
 *
 *  Created on: 5.3.2010
 *      Author: aahv
 */

#ifndef RICHTEXTEDIT_H
#define RICHTEXTEDIT_H

#include <QWidget>
#include <QDesktopWidget>
#include <QUrl>

#include "addlinkdialog.h"

namespace Ui {
    class RichTextEdit;
}

class RichTextEdit : public QWidget {
    Q_OBJECT
public:
    RichTextEdit(QWidget *parent = 0);
    ~RichTextEdit();
    void setExplanationText(const QString& text);
    void setText(const QString& text);
    QString text() const;
    void reset();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::RichTextEdit *ui;

signals:
    void showErrorNote(const QString& aError);

private slots:
    void on_boldButton_toggled(bool checked);
    void on_italicButton_toggled(bool checked);
    void on_quoteButton_toggled(bool checked);

    void on_linkButton_clicked();
    void addLink(const QString& title, const QUrl& link);
    
    void refocusEditor(); 

private:
    void insertTag(const QString& tag, bool begin);

    AddLinkDialog* dialog;
};

#endif // RICHTEXTEDIT_H
