#ifndef INPUTDIALOG_H
#define INPUTDIALOG_H

#include <QDialog>

class QAction;

namespace Ui {
    class InputDialog;
}

class InputDialog : public QDialog {
    Q_OBJECT
public:
    InputDialog(QString const & title, QString const & text,
                QString const & editorHint, QWidget *parent = 0);
    ~InputDialog();
    
    QSize sizeHint () const;

protected:
    void changeEvent(QEvent *e);
    void keyPressEvent(QKeyEvent * event );
    void showEvent(QShowEvent * event);
    
    virtual bool validateText(QString & text) { Q_UNUSED(text); return true; }

signals:
    void textComplete(const QString& text);

private slots:
    void onOk();
    void onCancel();

private:
    Ui::InputDialog *ui;
    
    QAction * iOkAction;
    QAction * iCancelAction;
};

#endif // INPUTDIALOG_H
