/*
 * ExplanatoryTextEdit.h
 *
 *  Created on: 12.1.2010
 *      Author: apoi
 */

#ifndef EXPLANATORYTEXTEDIT_H_
#define EXPLANATORYTEXTEDIT_H_

#include <QTextEdit>

class ExplanatoryTextEdit : public QTextEdit
{
    Q_OBJECT

public:
    ExplanatoryTextEdit(QWidget *aParent = 0, const QString& aExplanation = "DEFAULT_EXPLANATION");
    ~ExplanatoryTextEdit();

public:
    void SetExplanation (const QString &text);
    void setText(const QString& aValue);
    QString text() const;
    
    void insertText(const QString& text);

protected:
    /** Change the color of the existing text */
    void changeTextColor (const QColor &color);

    /* Maintain iDefault state */
    void focusInEvent(QFocusEvent *e);
    void focusOutEvent(QFocusEvent *e);

    /** Required for maemo on-screen keyboard; we lose focus while it is displayed */
    void inputMethodEvent (QInputMethodEvent *e);

    void hideEvent(QHideEvent *);

private slots:
    /** Update widget height to fit our entire document contents */
    void updateHeight ();

    /** Update parent QScrollArea scrolling position to keep our cursor visible */
    void updateScroll ();

private:
    /** Background text to show when input is empty */
    QString iExplanation;

    /** Showing background text? */
    bool iDefault;

};

#endif /* EXPLANATORYTEXTEDIT_H_ */
