/*
 * ExplanatoryLineEdit.h
 *
 *  Created on: 11.1.2010
 *      Author: apoi
 */

#ifndef EXPLANATORYLINEEDIT_H_
#define EXPLANATORYLINEEDIT_H_

#include <QLineEdit>

class ExplanatoryLineEdit : public QLineEdit
{
    Q_OBJECT

public:
    ExplanatoryLineEdit(QWidget *aParent = 0, const QString& aExplanation = "DEFAULT_EXPLANATION");
    ~ExplanatoryLineEdit();

public:
    void setText(QString const & aText);
    QString text() const;
    void SetExplanation(const QString& aExplanation);
    void SetPasswordMasking(bool aMaskPassword);
    void Clear();

protected:
    void focusInEvent(QFocusEvent *e);
    void focusOutEvent(QFocusEvent *e);
    void inputMethodEvent (QInputMethodEvent *e);
    void hideEvent(QHideEvent *);

private slots:	
    void textEdited(const QString& aText);

private:
    void Update();
    
private:
    QString iExplanation;
    QString iValue;
    QLineEdit::EchoMode iActiveEchoMode;
};

#endif /* EXPLANATORYLINEEDIT_H_ */
