#ifndef BUTTONGRAPHICSPROXY_H_
#define BUTTONGRAPHICSPROXY_H_

#include <QGraphicsProxyWidget>
#include <QPushButton>

// QGRaphicsProxyWidget doesn't work properly on symbian...
class ButtonGraphicsProxy : public QGraphicsProxyWidget
{
    Q_OBJECT
    
    // Custom button accepts QEvent::ShortcutOverride events
    // in addition to QEvent::KeyPress events
    class CustomButton : public QPushButton
    {
    public:
        CustomButton(QString const & name) : QPushButton(name) {}
        bool event(QEvent * event)
            {
            if(event->type() == QEvent::KeyPress || event->type() == QEvent::ShortcutOverride)
                {
                QKeyEvent *k = static_cast<QKeyEvent *>(event);
                if(hasFocus() && k->key() == Qt::Key_Select)
                    {
                    click();
                    event->accept();
                    return true;
                    }
                }
            return QPushButton::event(event);
            }
    };
    
public:
    ButtonGraphicsProxy(QString const & buttonName, QGraphicsItem * parent)
      : QGraphicsProxyWidget(parent)
        {
        button_ = new CustomButton(buttonName);
        setWidget(button_);
        }
    
    QPushButton * button() { return button_; }
    
private:
    QPushButton * button_;
};

#endif /* BUTTONGRAPHICSPROXY_H_ */
