/*
 * busyindicator.h
 *
 *  Created on: 30.4.2010
 *      Author: jlep
 */

#ifndef BUSYINDICATOR_H_
#define BUSYINDICATOR_H_

#include <QObject>
#include <QPixmap>
#include <QTimer>

/*!
 * Animated pixmap.
 */
class BusyIndicator : public QObject
{
    Q_OBJECT

public:
    BusyIndicator(QObject *parent);
    ~BusyIndicator();
    /*!
     * Start/Stop animations.
     */
    void Activate();
    void Deactivate();
    bool IsActive() { return iActive; }

    QPixmap& PixmapToDraw();

protected slots:
    void tick ();

signals:
    void changed ();

private:
    // In QObject tree
    QTimer* iTimer;
    // Members
    bool    iActive;
    int     iPictureWidth;
    int     iIndex;
    QList<QPixmap> iSprites;
};

#endif /* BUSYINDICATOR_H_ */
