#ifndef ADDPOSTVIEW_H
#define ADDPOSTVIEW_H

#include <QFrame>
#include <QStringList>
#include <QTimer>
#include "ui_addpostview.h"
#include "wpcustomviewbasicdata.h"
#include "WPData.h"
#include "LocationFinder.h"
#include "DialogController.h"

class BlogView;

class AddPostView : public QFrame, public WPCustomViewBasicData
{
    Q_OBJECT

public:
    AddPostView(BlogView *parent = 0);
    ~AddPostView();
    void NewPost(WPDataBlog *aBlog);
    void EditPost(WPDataBlog *aBlog, WPPost aPost);

    /** New set of categories selected for post */
    void SelectCategories (const QStringList &categories);

signals:
    void ShowErrorNote(const QString& aError);
    void ResolveFormattedAddress(qreal latitude, qreal longitude);

public slots:
    void SavePost();
    void ImagesAdded(const QStringList& aFilenames);
    void VideosAdded(const QStringList& aFilenames);
    void AddPhotosClicked(bool aDummy);
    void AddVideosClicked(bool aDummy);
    void AddLocationDataBoxClicked(int newState);
    void AddLocationButtonPressed();
    #if defined(HAVE_QTM_LOCATION)
    void LocationUpdated();
    #endif // defined(HAVE_QTM_LOCATION)
    void setFocus();
    void FormattedAddressResolved(qreal latitude, qreal longitude, const QString &formattedAddress);

private:
    void ShowSelectedCategories();

private slots:
    void CategoriesClicked();
    void Cancel();
    
private:
    Ui::AddPostView ui;
    BlogView* iParent;

    int iCategoryListLength;
    QStringList iCategories;

    WPDataBlog* iDataBlog;
    WPPost iPost;

    QStringList iAddedImages;
    QStringList iAddedVideos;

#if defined(HAVE_QTM_LOCATION)
    QtMobility::QGeoPositionInfo iLocation;
#endif //defined(HAVE_QTM_LOCATION)
    LocationFinder iLocationFinder;

};

#endif // ADDPOSTVIEW_H
