/*
 * SplashScreen.h
 *
 *  Created on: 8.9.2010
 *      Author: sber
 */

#ifndef SPLASHSCREEN_H_
#define SPLASHSCREEN_H_

#include <QSvgWidget>
#include <QLabel>
#include <QVBoxLayout>
#include <QHBoxLayout>

class SplashScreen : public QWidget
{
    Q_OBJECT
    
public:
    SplashScreen()
    {
        setObjectName("SplashScreen");
    
        QVBoxLayout * vLayout = new QVBoxLayout(this);
        QHBoxLayout * hLayout = new QHBoxLayout(this);
        
        QSvgWidget * svg = new QSvgWidget(":/images/wp-logo.svg", this);
        svg->setFixedSize(200, 200);
        
        QLabel * label = new QLabel(tr("WordPress for Nokia"), this);
        label->setAlignment(Qt::AlignCenter);
        
        vLayout->addStretch();
        vLayout->addItem(hLayout);
        vLayout->addWidget(label);
        vLayout->addStretch();

        hLayout->addStretch();
        hLayout->addWidget(svg);
        hLayout->addStretch();
    }
};


#endif /* SPLASHSCREEN_H_ */
