/*
 * SinglePostView.h
 *
 *  Created on: 14.12.2009
 *      Author: apoi
 */

#ifndef SINGLEPOSTVIEW_H
#define SINGLEPOSTVIEW_H

#include <QList>
#include <QPointer>
#include "MDragWidget.h"
#include "wpcustomviewbasicdata.h"
#include "WPData.h"

class BlogView;
class WPCommentList;
class WPScrollArea;
class SinglePostData;
class AddComment;

class SinglePostView : public MDragWidget, public WPCustomViewBasicData
{
    Q_OBJECT

public:
    SinglePostView(BlogView& parent);
    ~SinglePostView();
    
public:
    void ShowPost(const WPDataBlog& aBlog, WPPost aPost);

    bool MDragWidgetIsDragging() const;
    QSize VisibleSize() const;
    void ScrollToTop();

public slots:
    void UpdateData(const WPDataBlog& aBlog);

private slots:
    void CloseView();

private:
    // Data objects
    BlogView& iParent;
    WPPost iPost;
    WPCommentList* iListbox;

    // UI objects
    WPScrollArea* iScrollArea;
    SinglePostData* iPostData;

    QPointer<AddComment> iAddComment;
};

#endif // SINGLEPOSTVIEW_H
