/*
 * SinglePostData.cpp
 *
 *  Created on: 16.12.2009
 *      Author: apoi
 */

#include <QDesktopWidget>

#include "SinglePostData.h"
#include "WPNetworkEngine.h"

SinglePostData::SinglePostData(QWidget* parent, WPPost post) : QFrame(parent)
{
    ui.setupUi(this);

    ui.title->setTextFormat(Qt::RichText);
    ui.title->setWordWrap(true);
    ui.title->setText(post->iTitle);

    ui.content->setTextFormat(Qt::RichText);
    ui.content->setText(post->GetDisplayHTML());

    ui.date->setText(
            tr("by %1, %2").arg(post->iWpAuthorDisplayName).arg(post->GetShortLocalTimeString())
    );
    ui.categories->setText(tr("Categories: ") + post->iCategories.join(", "));

	if (post->iMtKeywords.isEmpty())
		ui.tags->hide();
	else
	    ui.tags->setText(tr("Tags: ") + post->iMtKeywords);
	
	doLabelClippingHack();
}

SinglePostData::~SinglePostData()
{

}

void SinglePostData::resizeEvent(QResizeEvent * e)
{
    QFrame::resizeEvent(e);
    doLabelClippingHack();
}

void SinglePostData::doLabelClippingHack()
{
    ui.content->setMaximumWidth(parentWidget()->width() - 1);
}
