/*
 * ProgressDialog.cpp
 *
 *  Created on: 18.12.2009
 *      Author: apoi
 */

#include <QDesktopWidget>
#include <QKeyEvent>

#include "ProgressDialog.h"

ProgressDialog::ProgressDialog (QWidget *parent, bool cancelable) : QDialog(parent)
{
#ifdef Q_WS_MAEMO_5
    setWindowFlags(Qt::Dialog);
#else
    setWindowFlags(Qt::Popup);
#endif

    ui.setupUi(this);
    ui.titleLabel->setText(tr("Please wait"));

    connect(ui.pushButton, SIGNAL(clicked()), this, SIGNAL(canceled()));
    
    if (cancelable)
        ui.pushButton->setText(tr("Cancel"));
}

ProgressDialog::~ProgressDialog()
{

}
    
void ProgressDialog::ShowTaskProgress (const QString &status)
{
    ui.actionLabel->setText(status);
    
    open();

#ifdef Q_OS_SYMBIAN
    // XXX: center popup, does this happen by default?
    QSize parentSize = QApplication::desktop()->screenGeometry().size();
    move((parentSize.width() - width()) / 2, (parentSize.height() - height()) / 2);
#endif
}

void ProgressDialog::keyPressEvent(QKeyEvent * event)
{
    if (event->key() == Qt::Key_Select || event->key() == Qt::Key_Context1)
    {
        canceled();
        event->accept();
    }
    else
    {
        QDialog::keyPressEvent(event);
    }
}

