#ifndef LOCATIONFINDER_H
#define LOCATIONFINDER_H

#if !defined(HAVE_QTM_LOCATION)

struct LocationFinder {};

#else

#include <QObject>
#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>
#include <QVector2D>

using QtMobility::QGeoPositionInfo;
using QtMobility::QGeoPositionInfoSource;

class LocationFinder : public QObject {
    Q_OBJECT

public:
    LocationFinder();
    virtual ~LocationFinder();

    const QGeoPositionInfo& getCurrentPosition() const;
    QString getFormattedAddress() const;
    
    void reset();
    
    void startSearchingForLocation();

    void stopSearchingForLocation();

public slots:
    void positionUpdated(const QGeoPositionInfo &update);
    void fakePositionUpdate();
    void formattedAddressResolved(qreal latitude, qreal longitude, const QString &formattedAddress);

signals:
    void positionUpdated();
    void timeout();

private:
    void saveLocationToSettings();
    void loadLocationFromSettings();

    bool isCloseToLastPosition(const QVector2D &pos);

private:
    static QGeoPositionInfoSource* positionSource;
    QGeoPositionInfo lastPosition;
    QString formattedAddress;

};

#endif // defined(HAVE_QTM_LOCATION)

#endif // LOCATIONFINDER_H
