#ifndef LOCATIONBUTTON_H_
#define LOCATIONBUTTON_H_

#include <QDateTime>
#include <QPushButton>
#if defined(HAVE_QTM_LOCATION)
#include <QGeoPositionInfo>
#endif // defined(HAVE_QTM_LOCATION)

class QResizeEvent;
class QTimer;
class QIcon;

class LocationButton : public QPushButton
    {
    Q_OBJECT
    
public:
    LocationButton(QWidget * parent = 0);
    virtual ~LocationButton();
    
    void resetPosition();
    void setNotSupported();
    void setBusy(bool busy);
    void setFormattedAddress(const QString& address);
#if defined(HAVE_QTM_LOCATION)
    void setPosition(QtMobility::QGeoPositionInfo const & newPosition);
#endif // defined(HAVE_QTM_LOCATION)
    
private slots:
    void timerTimeout();

protected:
    // make protected
    void setText(const QString & str) { QPushButton::setText(str); } 
    
    // override
    void resizeEvent(QResizeEvent* event);
    
private:
    void updateText();
    int getTextWidth();
    QString formatTimeSince(const QDateTime &t);
    
private:
    bool supported;
    QTimer* timer;
    QIcon *icons;
    int iconIndex;

    QString formattedAddress;
#if defined(HAVE_QTM_LOCATION)
    QtMobility::QGeoPositionInfo position;
#endif // defined(HAVE_QTM_LOCATION)
    };

#endif /* LOCATIONBUTTON_H_ */
