#include "ListTitle.h"

#include <QPainter>

ListTitle::ListTitle(QGraphicsItem * parent, const ThemeData &themeData)
  : QGraphicsWidget(parent), themeData(themeData)
{
    static const qreal height = themeData.iListTitleMargin + themeData.iListTitleHeight + themeData.iListTitleMargin;

    setMinimumHeight(height);
    setMaximumHeight(height);
    
    setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed));
}

void ListTitle::paint(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
    Q_UNUSED(option)
    Q_UNUSED(widget)
    
    if(boundingRect().height() == 0) { return; }
    
    QFont font;
    font.setPixelSize(themeData.iListTitleHeight);
    painter->setFont(font);
    
    QPoint drawPoint(themeData.iListItemContentHMargin, themeData.iListTitleMargin + themeData.iListTitleHeight); 
    painter->setPen(Qt::white);
    painter->drawText(drawPoint, text);
    
    drawPoint += QPoint(1, -1);
    painter->setPen(QColor(87, 87, 87));
    painter->drawText(drawPoint, text);
}
