/*
 * DialogController.h
 *
 *  Created on: 5.1.2010
 *      Author: apoi
 */

#ifndef DIALOGCONTROLLER_H_
#define DIALOGCONTROLLER_H_

#include <QObject>
#include <QWidget>

#include "WPNetworkEngine.h"

class BlogView;
class ErrorDialog;
class ProgressDialog;
   
class DialogController : public QObject
{
    Q_OBJECT

public:
    DialogController(BlogView *parent, bool cancellable = false);
    ~DialogController();

public slots: /* UI -> */
    /**
     * Display a modal progress dialog for the currently executing set of tasks, automatically hiding
     * it once all tasks complete.
     */
    void ShowTaskProgress ();

    /**
     * Hide any currently visible modal progress dialog.
     *
     * The tasks will continue executing in the background.
     */
    void HideTaskProgress ();

    /** Display modal message that the user must dismiss to continue */
    void ShowInfoNote (const QString &title, const QString &message);
    
    /** Display modal message that the user must dismiss to continue */
    void ShowErrorNote (const QString &error);

public slots: /* Network -> */

    void TaskStarted (TWPNetworkEngineCommand command, bool foreground = false);
    void TaskFinished (TWPNetworkEngineCommand command);
    void TaskFailed (TWPNetworkEngineCommand command, QString msg);

  
signals: /* -> XXX */
    void TaskCancelled (TWPNetworkEngineCommand command);

private slots: /* Internal */
    /** 
     * Update the visible state of our progress dialog / busy indicator after a task has ended.
     *
     * Invokes UpdateTaskIdle after a 100ms delay to hide the progress indicator.
     */
    void UpdateTaskStatus ();

    /**
     * Hide the progress indicator if we are still idle.
     */
    void UpdateTaskIdle ();

private slots: /* Dialog -> */

    /**
     * Modal task progress dialog was canceled.
     *
     * Either exit the entire application, or cancel the task, if supported.
     */
    void ExitProgress ();

    /**
     * Error was aknowledged.
     *
     * If we have pending tasks, and we are supposed to be showing their progress, return to the
     * progress bar.
     */
    void ErrorAccepted ();

private:    
    /**
     * Display the modal error dialog.
     *
     * Hides the progress dialog if visible.
     */
    void ShowErrorDialog (const QString &title, const QString &message);

    /** Hide the currently visible error dialog */
    void HideErrorDialog ();
 
    /**
     * Display modal progress dialog for currently executing task
     */
    void ShowProgressDialog ();

    /** Hide the currently visible progress dialog */
    void HideProgressDialog ();

private:
    BlogView *iParent;

    /* Modal dialogs */
    ErrorDialog *iErrorDialog;
    ProgressDialog *iProgressDialog;
    
    /** Show task progress until idle? */
    bool iShowTaskProgress;

    /** List of pending commands*/
    QList<TWPNetworkEngineCommand> iCommandList;

    /** Map from command id -> description XXX: static */
    QStringList iCommandMessages;
    
    /** Is the button action cancel */
    bool cancellable;

};

#endif /* DIALOGCONTROLLER_H_ */
