/*
 * CheckableListItem.cpp
 *
 *  Created on: 8.1.2010
 *      Author: apoi
 */

#ifndef CHECKABLELISTITEM_H
#define CHECKABLELISTITEM_H

#include <QFrame>

class MDragWidget;
class QImage;
class ImageThumbnailThread;
class QPaintEvent;

namespace Ui {
    class CheckableListItem;
}

class CheckableListItem : public QFrame
{
    Q_OBJECT
    
public:
    CheckableListItem(const QString& aItemId, bool aChecked,
            ImageThumbnailThread & aThumbnailThread, MDragWidget& aParent);
    ~CheckableListItem();
    bool IsChecked() const;
    void SetCheckState(bool aState);
    const QString& ItemId() const;
    void InitImageItem(const QString& aFilename, const QString& aDate, const QString& aSize);
    void InitCategoryItem(const QString& aCategoryName, int aCategoryLevel);
    bool ThumbnailCreated() const;
    void CreateThumbnail();

protected:
    void changeEvent(QEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);
    void keyPressEvent(QKeyEvent *e);

private slots:
    void ThumbnailCreated(void * requester, QImage const aImage);
    
private:
    void CreateThumbnail(const QImage & aImage);
    void UpdateCheckState();
    
private:
    Ui::CheckableListItem *ui;

    const QString iItemId;
    bool iChecked;
    const MDragWidget& iParent;

    bool iThumbnailCreated;
    ImageThumbnailThread & iThumbnailThread; 
};

#endif // CHECKABLELISTITEM_H
