/*
 * BaseView.h
 *
 *  Created on: 5.11.2009
 *      Author: thyv
 */

#ifndef BLOGVIEW_H_
#define BLOGVIEW_H_

#include <QMainWindow>
#include <QGraphicsView>
#include <QDebug>

#include "WPData.h"
#include "busyindicator.h"
#include "themedatastorage.h"
#include "LazyInitPointer.h"
#include "UiData.h"

class QListWidgetItem;
class QStackedWidget;
class QTabWidget;
class QMenuBar;
class QAction;
class QFileSystemModel;

class WritePageView;
class AddPostView;
class SinglePostView;
class CategoryView;
class StatisticsView;

class SetupBlog;
class BlogSetupView;
class WPNetworkEngine;
class MediaSelectionList;
class DialogController;
class PannableView;
class WPMenu;
class WPTitleBar;
class WPTabbedListView;
class WPGraphicsView;

class BlogView : public QMainWindow
{

    Q_OBJECT

public:
    BlogView();
    ~BlogView();

    // The order is significant
    enum TMainView
    {
        ENoView = -1,
#ifdef XX_Q_WS_MAEMO_5
        EInitialSetupBlogView,
#endif
        ETabbedListView,
        EStatisticsView,
        EMediaSelectionView,
        ECategoryView, 
        EBlogsView, 
        EAddPostView, 
        EWritePageView,
        ESetupBlogView,
        ESinglePostView,
    };

    enum LayoutType
    {
        Invalid               = -1,

        Portrait              = 0,
        Landscape             = 1,
        LandscapeMenuAtBottom = 2
    };

    QStringList iViewTitle;

private:
    /** Build the list of menu items */
    void InitMenuItems ();

public:    
    void SaveBlogSetup(WPDataBlog *blog, const WPNetworkEndpoint &settings);

    void AddNewComment(WPPost aPost, const QString& aBody);
    void ShowImageList(const QStringList& aInitialSelections, bool aPostView); // Pass true if post view, false if pages view
    void ShowVideoList(const QStringList& aInitialSelections, bool aPostView); // Pass true if post view, false if pages view
    void SetActiveView(BlogView::TMainView aRefocusableView = BlogView::ENoView);

    void ActivateBusyIndicator();
    void DeactivateBusyIndicator();
    BusyIndicator& GetBusyIndicator();
signals:
    void SignalBlogListView();

protected:    
/* Layout management */
    /** Current layout */
    enum LayoutType iCurrentLayoutType;

    /** Show fullscreen widget */
    void ShowInWindow (QWidget *window);

    /** Show widget in our normal layout */
    void ShowInLayout (QWidget *view);
    
    /** Set main layout orientation. Doesn't do anything if the layout is the same */
    void SetLayout (LayoutType layoutType);

    /** Set main layout orientation based on our current screen dimensions */
    void SetAutoLayout ();

    /** Change view shown in layout */
    void SwitchView (TMainView aView);
    
    /** Window layout changed, update layout if needed */
    void resizeEvent (QResizeEvent *e);

public slots:
    void Exit();
    void Refresh();

/* Show windows */
    // Main layout
    void ShowInitialSetupBlogView();
    void ShowTabbedListView();

    // Pages
    void ShowEditPageView(WPPage aPage);
    void ShowWriteNewPageView();
    
    // Posts
    void ShowEditPostView(WPPost post);
    void ShowSinglePostView(WPPost post);
    void ShowWriteNewPostView();
    void DeletePost(WPPost post);
    void ReplyToComment(WPComment aComment);
    void ImagesSelected(QStringList aFilenames);
    void VideosSelected(QStringList aFilenames);

    // Blogs
    void ShowBlogsView();
    void ShowNewBlogView();
    void ShowEditBlogView(const QString& aBlogId);
    void OpenBlog(const QString& aBlogId);
    bool DeleteBlog(const QString& aBlogId);

    // Categories
    void ShowCategoryView (const QStringList &categories);
    void CategoriesSelected (const QStringList &categories);
    void CategorySelectionCancelled ();

    // Statistics
    void OpenStatisticsView ();
    void ShowStatisticsView();
    
    inline ThemeData& GetThemeData() { return *iThemeData; }
    UiData & GetUiData() { return iUiData; }

public: // New functions
    WPNetworkEngine* GetNetworkEngine() const
    {
        return iNetworkEngine;
    }

    WPDataGravatars* GetGravatars() const
    {
        return iGravatars;
    }

    void keyPressEvent( QKeyEvent * event  );
    

private slots:
    void About();
    
    void ReallyShowMediaList();
    void CancelShowMediaList();
    void ShowNoAccessPointWarning();
    
private:
    // type = MediaSelectionList::MediaType, we don't want to include the header for this...
    void ShowMediaList(const QStringList& aInitialSelections, bool aPostView, int type);
    void MediaSelected();
    
    void InitSetupBlogView();
    void InitWritePageView();
    void InitAddPostView();
    void InitSinglePostView();
    void InitCategoryView();
    void InitStatisticsView();
    void InitBlogsView();
    
    // abstract
    BusyIndicator* iBusyIndicator;

    // main layout
    QWidget *iLayoutWidget;
    
    WPTitleBar *iTitleBar;
    QStackedWidget* iStackedWidget;
    WPMenu *iMenu;
    
    // widget views
#ifdef XX_Q_WS_MAEMO_5
    SetupBlog* iInitialSetupBlogView;
#endif
    
    WPTabbedListView *iTabbedListView;
    LazyInitPointer<SetupBlog, BlogView> iSetupBlogView;
    LazyInitPointer<WritePageView, BlogView> iWritePageView;
    LazyInitPointer<AddPostView, BlogView> iAddPostView;
    LazyInitPointer<SinglePostView, BlogView> iSinglePostView;
    LazyInitPointer<CategoryView, BlogView> iCategoryView;
    LazyInitPointer<StatisticsView, BlogView> iStatisticsView;
    MediaSelectionList* iMediaSelectionView;
    
    // graphics views
    LazyInitPointer<WPGraphicsView, BlogView> iBlogsView;
    LazyInitPointer<BlogSetupView, BlogView> iBlogsGraphicsWidget;
    LazyInitPointer<PannableView, BlogView> iPannableBlogWidget;
    
    // dialogues
    DialogController* iDialogController;
    
    // XXX: remove
    bool   iPortrait;

    // Model/Network
    WPNetworkEngine* iNetworkEngine;
    WPDataUsersBlogs* iBlogs;
    WPDataGravatars* iGravatars;
    
    int iCurrentView;
    bool iLandscapeSizeWorkaround;
    bool iAddMediaToPosts; // True if post view, false if pages view
    
    
    QAction* iManageBlogs;
    QAction* iActionWritePage; 
    QAction* iActionWritePost;
    QAction* iActionShowStatistics; 
    QAction* iActionRefresh;
    QAction* iAbout;
    QAction* iExit;

    ThemeData* iThemeData;
    UiData iUiData;
};
#endif //BLOGVIEW_H_
