
#include <QGraphicsLinearLayout>
#include <QDateTime>
#include <QMenu>
#include <QDesktopWidget>

#include "BlogSetupView.h"
#include "WPData.h"
#include "BlogView.h"
#include "wpbloggraphicslist.h"
#include "WPNetworkEngine.h"

BlogSetupView::BlogSetupView(BlogView* aParent, const QGraphicsView& aGraphicsView, PannableView* aPannableView)
  : iParent(aParent)
  , iGraphicsView(aGraphicsView)
  , iPannableView(aPannableView)
  , iCloseAction(new QAction(tr("Close"), this))
{
    iListbox = new WPBlogGraphicsList(aParent, aGraphicsView, aPannableView);
    iLayout = new QGraphicsLinearLayout(Qt::Vertical);
    iLayout->setSpacing(0);
    iLayout->setContentsMargins(0, 0, 0, 0);
    iLayout->addItem(iListbox);
    
	connect(iCloseAction, SIGNAL(triggered()), this, SLOT(CloseView()));
	iCloseAction->setSoftKeyRole(QAction::NegativeSoftKey);
    
    setLayout(iLayout);
}

BlogSetupView::~BlogSetupView()
{
    delete iListbox;
}

void BlogSetupView::resizeEvent(QGraphicsSceneResizeEvent *event)
{
    Q_UNUSED(event);

    // Set maximum width for the contained items, this
    // will reduce the amount of redraws
    if (iListbox) {
        iListbox->setGeometry(0, 0, size().width(), size().height());
    } 
}

void BlogSetupView::UpdateData(const WPDataUsersBlogs& aUsersBlogs)
{
	if (iListbox)
	    iListbox->UpdateData(aUsersBlogs);
}

void BlogSetupView::setFocus()
{
    if (iListbox)
        iListbox->setFocus();
}

void BlogSetupView::CloseView()
{
    // XXX: more generic
    iParent->ShowTabbedListView();
}


