#ifndef WPTABBEDLISTVIEW_H
#define WPTABBEDLISTVIEW_H

#include "wpgraphicsview.h"

#include <QGraphicsLinearLayout>

class PannableView;
class BlogView;
class WPTabbarGraphicsView;
class WPStackedGraphicsWidget;
class WPGraphicsList;
class WPPostGraphicsList;
class WPPageGraphicsList;
class WPCommentGraphicsList;

/**
 * The central comment/post/page list widget.
 *
 * Implemented using QGraphics.
 */
class WPTabbedListView : public WPGraphicsView
{
public:    
    WPTabbedListView (BlogView *blogView);

    /** XXX: wut */    
    void switchPreviousWidget ();
    void setFocus ();

protected:
    /** Switch tabs on left/right key nav */
    void keyPressEvent (QKeyEvent *event);
    
private:
    WPGraphicsList * CurrentList();

public: /* XXX: for signals */
    /** Tab menu widget */
    WPTabbarGraphicsView* iTabBarWidget;

    /** Switchable tab content */
    WPStackedGraphicsWidget* iTabContentWidget;
    
    /** Main layout for tab bar/content */
    QGraphicsLinearLayout*  iTabLayout;

    /* The various tabs */
    WPPostGraphicsList* iPostsView;
    PannableView* iPannablePostsWidget;

    WPPageGraphicsList* iPagesView;
    PannableView* iPannablePagesWidget;

    WPCommentGraphicsList* iCommentsView;
    PannableView* iPannableCommentsWidget;
};

#endif
