/*
 * wpstackedgraphicswidget.h
 *
 *  Created on: 20.5.2010
 *      Author: jlep
 */

#ifndef WPSTACKEDGRAPHICSWIDGET_H_
#define WPSTACKEDGRAPHICSWIDGET_H_

#include <QGraphicsWidget>

class BlogView;

class WPStackedGraphicsWidget : public QGraphicsWidget
{
public:
    WPStackedGraphicsWidget(QGraphicsWidget* aParent, BlogView & blogView);
    ~WPStackedGraphicsWidget();

    void AddWidget(QGraphicsWidget* aWidget);
    QGraphicsWidget* CurrentWidget();

    void SwitchPreviousWidget();
    void SwitchAndSetPreviousWidget(QGraphicsWidget* aWidget);
    void SwitchWidget(QGraphicsWidget* aWidget);

private:
    virtual void resizeEvent(QGraphicsSceneResizeEvent *event);
    void hideEvent(QHideEvent *event);

private:
    BlogView & iBlogView;
    QList<QGraphicsWidget*> iList;
    int iCurrentIndex;
    int iPreviousIndex;
};

#endif /* WPSTACKEDGRAPHICSWIDGET_H_ */
