#ifndef WPSCROLLAREA_H
#define WPSCROLLAREA_H

#include <QVBoxLayout>
#include <QScrollArea>
#include <QTime>

class QTimer;

class WPScrollArea : public QScrollArea
{
    Q_OBJECT

public:
    WPScrollArea(QWidget* parent = 0);
    ~WPScrollArea();

public:
    bool IsDragging() const;
    void addWidget(QWidget* aWidget);
    void removeWidget(QWidget* aWidget);
    void setWidget(QWidget* aWidget);
    bool focusNextPrevChild(bool next);
    bool eventFilter(QObject *, QEvent *);
    void InitLayout();
    void AddStretch();
    void ScrollToTop();
    QLayoutItem* itemAt(int aIndex) const;
    QSize GetVisibleContentSize() const;
    QPoint TopRightInGlobal() const;
    void DisableScrollAtWidget(QWidget* aWidget);
    void RemoveSelfScrollingWidget(QWidget* aWidget);
    void HandleScrollEvent(QKeyEvent* aEvent);

#ifndef Q_WS_MAEMO_5
signals:
    void ScrollingStopped();

private:
    void StopScrolling();
#endif

protected:
    void mousePressEvent(QMouseEvent* aEvent);
    void mouseMoveEvent(QMouseEvent* aEvent);
    void mouseReleaseEvent(QMouseEvent* aEvent);
    void timerEvent(QTimerEvent* aEvent);


private:
    QTime iDecelerationStarted;
    QTime iTimeStamp;
    int iSpeed;
    int iPreviousY;
    bool iDragging;
    int iTimerId;

    QFrame* iContent;
    QVBoxLayout* iLayout;

    QList<QWidget*> iScrollDisableWidgets;
};

#endif // WPSCROLLAREA_H
