/*
 * wppostgraphicslist.h
 *
 *  Created on: 19.5.2010
 *      Author: jlep
 */

#ifndef WPPOSTGRAPHICSLIST_H_
#define WPPOSTGRAPHICSLIST_H_

#include <QPointer>

#include "wpgraphicslist.h"
#include "wpgraphicslistitem.h"
#include "WPData.h"

class QLabel;
class WPPostGraphicsListItem;
class WPGraphicsListItem;

class PostGraphicsView;
class BlogView;

class ButtonGraphicsProxy;
class ListTitle;
class ShadowGraphicsItem;

class WPPostGraphicsList  : public WPGraphicsList
{
    Q_OBJECT

public:
    WPPostGraphicsList (const QGraphicsView& aGraphicsView, 
        BlogView* aBlogView, PannableView* aPannableView);
    ~WPPostGraphicsList();

public slots:
    void UpdatePostData(const WPDataBlog& aBlog);

    void PostChanged(WPPost aPost);
    void PostRemoved(WPPost aPost);
    void PostAdded(WPPost aPost);
    
signals:
    void OpenClicked(WPPost aPost);
    void EditClicked(WPPost aPost);
    void DeleteClicked(WPPost aPost);
    
private:
    void AddPost(WPPost aPost);
    void RemovePost (WPPost aPost);

    void UpdateLabels();
    
private: // WPGraphicsList implementation
    void PopulatePopupMenuForCurrentItem(PopupMenu* aPopupMenu);
    bool IsFocusable(QGraphicsLayoutItem * item);
    
private:
    WPPostGraphicsListItem * CurrentItem()
        { return reinterpret_cast<WPPostGraphicsListItem *> (CurrentListItem()); }
    WPPostGraphicsListItem * LayoutToListItem(QGraphicsLayoutItem * item)
        { WPGraphicsListItem * listItem = qgraphicsitem_cast<WPGraphicsListItem *>(item->graphicsItem());
          return reinterpret_cast<WPPostGraphicsListItem *>(listItem); }
    
    void OrderedInsert(QGraphicsLinearLayout & layout, WPPostGraphicsListItem & item);
    WPPostGraphicsListItem * RemoveFromLayout(QGraphicsLinearLayout & layout, WPPost post);

private slots:
    void Open();
    void Edit();
    void Delete();
   
private: // Data
    QString iTitle;
    
    ListTitle* iDraftsLabel;
    ListTitle* iPostsLabel;
    
    QAction* iActionOpen;
    QAction* iActionEdit;
    QAction* iActionDelete;
    
    ButtonGraphicsProxy* iNewPostButton;
    
    QGraphicsProxyWidget* iMenuProxy;
    
    QGraphicsLinearLayout * iDraftsLayout;
    ShadowGraphicsItem * iDraftsTopShadow;
    ShadowGraphicsItem * iDraftsBottomShadow;
    
    QGraphicsLinearLayout * iPostsLayout;
    ShadowGraphicsItem * iPostsTopShadow;
    ShadowGraphicsItem * iPostsBottomShadow;
    
    QPointer<WPDataBlog> iCurrentBlog;
};

#endif /* WPPOSTGRAPHICSLIST_H_ */
