#ifndef WPPageGraphicsListItem_H
#define WPPageGraphicsListItem_H

#include "wpgraphicslistitem.h"
#include "WPData.h"

class QPixmap;
class BusyIndicator;
class HtmlPainter;

class WPPageGraphicsListItem : public WPGraphicsListItem
{
    Q_OBJECT

public:
    WPPageGraphicsListItem(WPPage aPage, BusyIndicator& aBusyIndicator, ThemeData& aThemeData);
    ~WPPageGraphicsListItem();
    
public: // New functions
    void Update(const WPDataComment& aComment);
    WPPage GetPage();
    
    bool operator<(WPPageGraphicsListItem const & other);
    
public: // WPGraphicsListItem implementation
    void paintContent(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = 0);
    bool IsBusy();
    bool HasError();
    void handleGeomeryChange();

private: // Data
    WPPage iPage;
    
    QString iAuthorAndDate;
    HtmlPainter * iTitle;

    static struct Geometry {
        Geometry () : iHeight(0) { }

        /** Calculate rects*/
        void update (WPPageGraphicsListItem & parent);

        /** Total height */
        int height () { return iHeight; }
        
        
        QSizeF iCachedSize;
        int iHeight;

        QRect iTitle;
        QRect iAuthorAndDate;

    } iGeometry;
};

#endif // WPPageGraphicsListItem_H
