/*
 * wpcollectiongraphicslist.h
 *
 *  Created on: 19.5.2010
 *      Author: jlep
 */

#ifndef WPPAGEGRAPHICSLIST_H_
#define WPPAGEGRAPHICSLIST_H_

#include <QGraphicsWidget>
#include <QGraphicsView>
#include <QList>
#include <QPointer>

#include "wpgraphicslist.h"
#include "wpgraphicslistitem.h"
#include "WPData.h"

class QLabel;
class ButtonGraphicsProxy;

class PopupMenu;
class PageGraphicsView;
class WPGraphicsListItem;
class WPPageGraphicsListItem;
class QGraphicsProxyWidget;
class BlogView;

class ListTitle;
class ShadowGraphicsItem;

class WPPageGraphicsList : public WPGraphicsList
{
    Q_OBJECT

public:

    WPPageGraphicsList(const QGraphicsView& aGraphicsView,
        BlogView* aBlogView, PannableView* aPannableView);
    ~WPPageGraphicsList();

public slots:
    void UpdatePageData(const WPDataBlog& aBlog);

    void PageChanged(WPPage aPage);
    void PageRemoved(WPPage aPage);
    void PageAdded(WPPage aPage);

signals:
    void OpenClicked(WPPage aPage);
    void EditClicked(WPPage aPage);
    
private:
    void AddPage(WPPage aPage);
    void RemovePage (WPPage aPage);
   
    void UpdateLabels();
    
private: // WPGraphicsList implementation
    void PopulatePopupMenuForCurrentItem(PopupMenu* aPopupMenu);
    bool IsFocusable(QGraphicsLayoutItem * item);
    
private:
    WPPageGraphicsListItem * CurrentItem()
        { return reinterpret_cast<WPPageGraphicsListItem *> (CurrentListItem()); }
    WPPageGraphicsListItem * LayoutToListItem(QGraphicsLayoutItem * item)
        { WPGraphicsListItem * listItem = qgraphicsitem_cast<WPGraphicsListItem *>(item->graphicsItem());
          return reinterpret_cast<WPPageGraphicsListItem *>(listItem); }
    
    void OrderedInsert(QGraphicsLinearLayout & layout, WPPageGraphicsListItem & item);
    WPPageGraphicsListItem * RemoveFromLayout(QGraphicsLinearLayout & layout, WPPage page);

private slots:
    void Open();
    void Edit();
    void Delete();

private: // Data
    QString iTitle;

    ListTitle* iDraftsLabel;
    ListTitle* iPagesLabel;

    QAction* iActionOpen;
    QAction* iActionEdit;
    QAction* iActionDelete;
    
    ButtonGraphicsProxy* iNewPageButton;
 
    QGraphicsLinearLayout * iDraftsLayout;
    ShadowGraphicsItem * iDraftsTopShadow;
    ShadowGraphicsItem * iDraftsBottomShadow;
    
    QGraphicsLinearLayout * iPagesLayout;
    ShadowGraphicsItem * iPagesTopShadow;
    ShadowGraphicsItem * iPagesBottomShadow;
    
    QPointer<WPDataBlog> iCurrentBlog;
};

#endif /* WPPAGEGRAPHICSLIST_H_ */
