#include "wpgraphicsview.h"

#include "scopedtracer.h"

WPGraphicsView::WPGraphicsView (QWidget *parent) :
    QGraphicsView(parent)
{
    // scene
    iScene = new QGraphicsScene();

    setScene(iScene);
    
    // resize to fill up all available space
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
}
    
void WPGraphicsView::addItem (QGraphicsItem *item)
{
    iScene->addItem(item);
}
    
void WPGraphicsView::setWidget (QGraphicsWidget *widget)
{
    iWidget = widget;

    iScene->addItem(widget);
}
    
void WPGraphicsView::resizeEvent (QResizeEvent *event)
{
    ScopedTracer tracer("WPGraphicsView::resizeEvent");
    tracer << event->size();
	
    QGraphicsView::resizeEvent(event);

    QSize size = this->size();
    
    // fit displayed widget in scene to fit our full view
    iWidget->resize(size);

    // fix scene view rect to display entire widget
    QRectF sceneRect(0, 0, size.width(), size.height());

    setSceneRect(sceneRect);
    centerOn(sceneRect.center());
}

