#ifndef WPGRAPHICSLISTITEM_H
#define WPGRAPHICSLISTITEM_H

#include <QKeyEvent>
#include <QGraphicsWidget>

#include "wpcustomgraphicsitemtypes.h"

class QPixmap;
class BusyIndicator;
class ThemeData;

class WPGraphicsListItem : public QGraphicsWidget
{
    Q_OBJECT

public:
    WPGraphicsListItem(BusyIndicator& aBusyIndicator, ThemeData& aThemeData);
    virtual ~WPGraphicsListItem() {}

public:
    QPointF TopRight() const;
    QRectF boundingRect() const;
    void MarkBogusFocus(bool aActive);
    bool BogusFocus();

    void paint(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = 0);
    
    enum { Type = WPGraphicsListItemType };
    int type() const { return Type; }

public: // Pure virtual functions
    virtual void paintContent(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = 0) = 0;
    virtual bool IsBusy() = 0;
    virtual bool HasError() = 0;
    virtual void handleGeomeryChange() = 0;

public:
    static const int ItemMinimumHeight = 145;

public slots:
    void resizeEvent(QGraphicsSceneResizeEvent *e);

signals:
    void Selected(WPGraphicsListItem* aItem);

protected:
    int contentXOffset() const { return iCol1ContentXOffset; }
    
    ThemeData& iThemeData;

private:
    void mousePressEvent(QGraphicsSceneMouseEvent *e);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *e);
    void keyPressEvent(QKeyEvent *e);
    void timerEvent(QTimerEvent*);

    void drawBackground(QPainter * painter);
    void drawBorder(QPainter * painter);
    
private: // Data
    
    int iBusyX;
    int iBusyY;
    
    int iCol1ContentXOffset;
    QRectF iBoundingRect;

    int iTimerId;
    BusyIndicator& iBusyIndicator;

    bool iHasMenuFocus;
};

#endif // WPGRAPHICSLISTITEM_H
