#ifndef WPCONFIRMDIALOG_H
#define WPCONFIRMDIALOG_H

#include <QtGui/QDialog>
#include "ui_wpconfirmdialog.h"

/* Utility macro for most common use case:
 * return from function if user selects "no" from dialog
 * Also works around some Qt bugs in symbian
 */
#define WP_CONFIRM_AND_RETURN_ON_FALSE if(!WPConfirmDialog::RunDialog()) { return; }

class WPConfirmDialog : public QDialog
{
    Q_OBJECT

public:
    static inline bool RunDialog() { WPConfirmDialog dlg; return dlg.ConfirmUser(); } 
    
public:
    WPConfirmDialog(QWidget *parent = 0);
    ~WPConfirmDialog();

    bool ConfirmUser();
    
    void keyPressEvent(QKeyEvent * event );

private slots:
    void yesClicked();
    void noClicked();

private:
    Ui::WPConfirmDialogClass ui;
    bool iResponse;
    
    QAction * iYesAction;
    QAction * iNoAction;
};

#endif // WPCONFIRMDIALOG_H
