#include "wpconfirmdialog.h"

#include <QAction>
#include <QKeyEvent>

WPConfirmDialog::WPConfirmDialog(QWidget *parent)
    : QDialog(parent), iResponse(false)
{
#ifdef Q_WS_MAEMO_5
    setWindowFlags(Qt::Dialog);
#else
    setWindowFlags(Qt::Popup);
#endif
	ui.setupUi(this);
	
	iYesAction = new QAction(this);
	addAction(iYesAction);
	//iYesAction->setSoftKeyRole(QAction::PositiveSoftKey);
	connect(ui.yesButton, SIGNAL(clicked()), iYesAction, SLOT(trigger()));
	connect(iYesAction, SIGNAL(triggered()), this, SLOT(yesClicked()));
	
	iNoAction = new QAction(this);
	addAction(iNoAction);
	//noAction->setSoftKeyRole(QAction::NegativeSoftKey);
	connect(ui.noButton, SIGNAL(clicked()), iNoAction, SLOT(trigger()));
	connect(iNoAction, SIGNAL(triggered()), this, SLOT(noClicked()));
}

WPConfirmDialog::~WPConfirmDialog()
{
}

bool WPConfirmDialog::ConfirmUser()
{
    exec();
    return iResponse;
}

void WPConfirmDialog::yesClicked()
{
    accept();
    iResponse = true; 
}

void WPConfirmDialog::noClicked()
{
    reject();
    iResponse = false;
}

void WPConfirmDialog::keyPressEvent ( QKeyEvent * event  )
{
    if (event->key() == Qt::Key_Context1 )
    {
        iYesAction->trigger();
        event->accept();
    }
    else if(event->key() == Qt::Key_Context2)
    {
        iNoAction->trigger();
        event->accept();
    }
    else
    {
        QDialog::keyPressEvent(event);
    }
}
