#ifndef WPCOMMENTLISTITEM_H
#define WPCOMMENTLISTITEM_H

#include "ui_wpcommentlistitem.h"
#include <QKeyEvent>
#include <QMouseEvent>
#include <QFrame>

#include "WPData.h"

class MDragWidget;

class WPCommentListItem : public QFrame
{
    Q_OBJECT

public:
    WPCommentListItem(MDragWidget& aParent, WPComment aComment, bool aShowFullComment);
    ~WPCommentListItem();
    
public: // New functions
    void SetAvatarImage(const QPixmap& aPixmap);
    WPComment GetComment() const;
    QPoint TopRight() const;
    void ChangeViewMode();
    bool ShowFullComment() const { return iShowFullComment; };
    
    void Update (WPComment aComment);
    
public:
    static const int ItemMinimumHeight = 128;

signals:
    void CommentItemSelected(WPCommentListItem* aItem);

private:
    void mouseReleaseEvent(QMouseEvent *e);
    void keyPressEvent(QKeyEvent *e);
    void SetViewMode(bool aViewMode);

private: // Data
    bool iShowFullComment;
    MDragWidget& iParent;
    Ui::WPCommentListItem ui;
    WPComment iComment;

};

#endif // WPCOMMENTLISTITEM_H
