#ifndef WPCOMMENTLIST_H
#define WPCOMMENTLIST_H

#include <QWidget>
#include <QList>
#include "MDragWidget.h"

#include "busyindicator.h"
#include "themedatastorage.h"
#include "WPData.h"

class QLabel;
class QVBoxLayout;

class PopupMenu;
class WPCommentListItem;
class WPNetworkEngine;
class WPScrollArea;
class ThemeData;

class WPCommentList : public MDragWidget
{
    Q_OBJECT

public:
    WPCommentList(QListIterator<WPComment> aData,
                  WPDataGravatars *aGravatars, WPScrollArea& aScrollArea, ThemeData& aThemeData,
                  bool aShowFullComment = false);
    ~WPCommentList();

public:
    bool MDragWidgetIsDragging() const;
    QSize VisibleSize() const;
    void setFocus();

public slots:
    void GravatarUpdated (const QString &email, const QPixmap &pixmap);
    void ShowContextMenu(WPCommentListItem* aItem);
    
    void CommentChanged(WPComment aComment);
    void CommentRemoved(WPComment aComment);
    void CommentAdded(WPComment aComment);

protected:
    void resizeEvent(QResizeEvent* event);
    QPoint getMenuLocation(QPoint itemPoint);

private slots:
    void MenuHiding();
    void Approve();
    void Unapprove();
    void View();
    void Delete();
    void Spam();

private:
    void AddComment(WPComment aComment, bool aShowFullComment);
    void RemoveComment (WPComment aComment);
    
    void SetLabelText();
    
    void DecrementUnapproved();
    void DecrementApproved();
    
    void IncrementUnapproved();
    void IncrementApproved();

private: // Data
    WPDataGravatars* iGravatars;
    WPScrollArea& iScrollArea;

    QList<WPCommentListItem*> iItems;
    WPCommentListItem* iCurrentItem;
    QVBoxLayout* iLayout;
    
    QLabel* iUnapprovedLabel;
    QLabel* iApprovedLabel;
    int iUnapproved;
    int iApproved;

    QAction* iActionApprove;
    QAction* iActionUnapprove;
    QAction* iActionView;
    QAction* iActionHide;
    QAction* iActionDelete;
    QAction* iActionSpam;

    PopupMenu* iPopupMenu;
};

#endif // WPCOMMENTLISTITEM_H
