#ifndef WPCOMMENTGRAPHICSLISTITEM_H
#define WPCOMMENTGRAPHICSLISTITEM_H

#include "wpgraphicslistitem.h"
#include "WPData.h"

class QPixmap;
class WPCommentGraphicsList;
class BusyIndicator;
class HtmlPainter;

class WPCommentGraphicsListItem : public WPGraphicsListItem
{
    Q_OBJECT

public:
    WPCommentGraphicsListItem(WPComment aComment, 
        bool aShowFullComment, BusyIndicator& aBusyIndicator, ThemeData& aThemeData);
    ~WPCommentGraphicsListItem();
    
public: // New functions
    void SetAvatarImage(const QPixmap &aPixmap);
    WPComment GetComment() const;
    void ChangeViewMode();
    bool ShowFullComment() const { return iShowFullComment; };
    void Update (WPComment aComment);
    
    // Order by date
    bool operator<(WPCommentGraphicsListItem const & other);
    
public: // WPGraphicsListItem implementation
    void paintContent(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = 0);
    bool IsBusy();
    bool HasError();
    void handleGeomeryChange();

private:
    void SetViewMode(bool aShowFullComment);
    void SetTitleFormatting();
    
private: // Data
    WPComment iComment;
    
    bool iShowFullComment;

    QPixmap iPixmap;
    QString iDate;
    
    HtmlPainter * iTitle;
    HtmlPainter * iText;
    
private: // Cached common geometry
    struct StandardGeometry {
        StandardGeometry();
        void update(WPCommentGraphicsListItem & parent);
        int height() { return iHeight; }
        
        // Common part
        QRect iPixmap;
        QRect iAuthor;
        QRect iDate;
        
        // Comment part
        QRect iTitle;
        QRect iComment;
        QRect iEmail;
        QRect iWebsite;
        
    protected:
        void updateHeight(ThemeData const & theme);
        
        int iHeight;
        QSizeF iInitSize;
    };
    
    struct ExpandedGeometry : public StandardGeometry {
        void update(WPCommentGraphicsListItem & parent);
    };
    
    /*static*/ StandardGeometry iStandardGeometry;
    ExpandedGeometry iExpandedGeometry;
};

#endif // WPCOMMENTGRAPHICSLISTITEM_H
