#ifndef WPCOMMENTGRAPHICSLIST_H
#define WPCOMMENTGRAPHICSLIST_H

#include <QPointer>

#include "wpgraphicslist.h"
#include "WPData.h"
#include "wpgraphicslistitem.h"

class QLabel;
class QVBoxLayout;

class WPCommentGraphicsListItem;
class QGraphicsProxyWidget;
class BlogView;

class ListTitle;
class ShadowGraphicsItem;

class WPCommentGraphicsList : public WPGraphicsList
{
    Q_OBJECT

public:
    WPCommentGraphicsList(BlogView* aBlogView, const QGraphicsView& aGraphicsView,
        PannableView* aPannableView);
    ~WPCommentGraphicsList();

signals:
    void ReplyToComment(WPComment aComment);

public slots:
    void GravatarUpdated (const QString &email, const QPixmap &pixmap);
    
    void UpdateCommentsData(const WPDataBlog& aBlog);
    
    void CommentChanged(WPComment aComment);
    void CommentRemoved(WPComment aComment);
    void CommentAdded(WPComment aComment);
    
private slots:
    void Approve();
    void Unapprove();
    void View();
    void Reply();
    void Delete();
    void Spam();

private:
    void AddComment(WPComment aComment, bool aShowFullComment);
    void RemoveComment (WPComment aComment);
    
    void UpdateLabels();
    
private: // WPGraphicsList implementation
    void PopulatePopupMenuForCurrentItem(PopupMenu* aPopupMenu);
    
    
private:
    WPCommentGraphicsListItem * CurrentItem()
        { return reinterpret_cast<WPCommentGraphicsListItem *> (CurrentListItem()); }
    WPCommentGraphicsListItem * LayoutToListItem(QGraphicsLayoutItem * item)
        { WPGraphicsListItem * listItem = qgraphicsitem_cast<WPGraphicsListItem *>(item->graphicsItem());
          return reinterpret_cast<WPCommentGraphicsListItem *>(listItem); }
    
    void OrderedInsert(QGraphicsLinearLayout & layout, WPCommentGraphicsListItem & item);
    WPCommentGraphicsListItem * RemoveFromLayout(QGraphicsLinearLayout & layout, WPComment comment);
    void UpdateGravatarsInLayout(QGraphicsLinearLayout & layout, const QString &email, const QPixmap &pixmap);
    
private: // Data
    WPDataGravatars*        iGravatars;
    
    ListTitle* iUnapprovedLabel;
    ShadowGraphicsItem * iUnapprovedTopShadow;
    ShadowGraphicsItem * iUnapprovedBottomShadow;

    ListTitle* iApprovedLabel;
    ShadowGraphicsItem * iApprovedTopShadow;
    ShadowGraphicsItem * iApprovedBottomShadow;
    
    QGraphicsLinearLayout * iUnapprovedLayout;
    QGraphicsLinearLayout * iApprovedLayout;

    QAction* iActionApprove;
    QAction* iActionUnapprove;
    QAction* iActionView;
    QAction* iActionHide;
    QAction* iActionReply;
    QAction* iActionDelete;
    QAction* iActionSpam;
    
    QPointer<WPDataBlog> iCurrentBlog;
};

#endif // WPCOMMENTGRAPHICSLIST_H
