#ifndef WPBLOGGRAPHICSLISTITEM_H_
#define WPBLOGGRAPHICSLISTITEM_H_

#include "wpgraphicslistitem.h"
#include "WPData.h"
#include "wpbloggraphicslist.h"

class WPBlogGraphicsListItem : public WPGraphicsListItem
{
    Q_OBJECT

public:
    WPBlogGraphicsListItem(const WPDataBlog& blog, BusyIndicator& busyIndicator, ThemeData& themeData);
    ~WPBlogGraphicsListItem();
    
public: // WPGraphicsListItem implementation
    void paintContent(QPainter* painter, const QStyleOptionGraphicsItem* option, QWidget* widget = 0);
    bool IsBusy();
    bool HasError();
    void handleGeomeryChange();

public slots:
	const WPDataBlog& getBlog() const;
    void calculateElidedTexts();

private: // Data
    const WPDataBlog& iBlog;
    
    QString iTitle;
    QString iStatus;
    QString iActivity;

    static struct Geometry {
        Geometry () : iHeight(0) { }

        /** Calculate rects*/
        void update (const QSizeF &size, const ThemeData &theme);

        /** Total height */
        int height () { return iHeight; }
        
        
        QSizeF iCachedSize;
        int iHeight;

        QRect iTitle;
        QRect iStatus;
        QRect iActivity;

    } iGeometry;
};

#endif /* WPBLOGGRAPHICSLISTITEM_H_ */
