#include "wpbloggraphicslist.h"
#include "wpbloggraphicslistitem.h"
#include "PopupMenu.h"
#include "BlogView.h"
#include "wpconfirmdialog.h"
#include "buttongraphicsproxy.h"

#include <QAction>
#include <QGraphicsProxyWidget>
#include <QGraphicsLinearLayout>

WPBlogGraphicsList::WPBlogGraphicsList(BlogView* aBlogView, const QGraphicsView& aGraphicsView,
	PannableView* aPannableView)
  : WPGraphicsList(aBlogView, aGraphicsView, aPannableView)
  , iBlogView(aBlogView)
{
	 // TODO find a proper way to align menu icon and text side by side.
	iActionOpen = new QAction(iThemeData.GetContextIcon(ThemeData::EOpen),tr("Open"), this);
	iActionEdit = new QAction(iThemeData.GetContextIcon(ThemeData::EEdit),tr("Edit"), this);
	iActionDelete = new QAction(iThemeData.GetContextIcon(ThemeData::ERemove),tr("Delete"), this);
	
	connect(iActionOpen,   SIGNAL(triggered()), this, SLOT(Open()));
	connect(iActionEdit,   SIGNAL(triggered()), this, SLOT(Edit()));
	connect(iActionDelete, SIGNAL(triggered()), this, SLOT(Delete()));
	
	iNewBlogButton = new ButtonGraphicsProxy(tr("Add new blog"), this);
	iNewBlogButton->button()->setObjectName("newBlogButton");
	iNewBlogButton->button()->setStyleSheet(iThemeData.iListButtonQss);
	connect(iNewBlogButton->button(), SIGNAL(clicked(bool)), this, SLOT(AddNewBlog()));
    
	iLayout->setContentsMargins(0, 5, 0, 0);

	iLayout->addItem(iNewBlogButton);
	iListLayout = AddLayout();
	iLayout->addStretch();
}

WPBlogGraphicsList::~WPBlogGraphicsList()
{
}

void WPBlogGraphicsList::UpdateData(const WPDataUsersBlogs& aUsersBlogs)
{
    ClearLayout(*iListLayout);

	for (QListIterator<WPDataBlog *> i(aUsersBlogs.GetBlogs()); i.hasNext(); ) {
		AddBlog(*i.next());
	}
	
	iTitle = tr("Blogs (%1)") .arg(aUsersBlogs.GetBlogs().size());
}

void WPBlogGraphicsList::AddBlog(const WPDataBlog& aBlog)
{
	WPBlogGraphicsListItem* item = new WPBlogGraphicsListItem(aBlog, iBusyIndicator, iThemeData);
	connect(item, SIGNAL(Selected(WPGraphicsListItem*)), this, SLOT(ShowContextMenu(WPGraphicsListItem*)));
	
	iListLayout->addItem(item);
}

void WPBlogGraphicsList::PopulatePopupMenuForCurrentItem(PopupMenu* aPopupMenu)
{
	aPopupMenu->addAction(iActionOpen);
	aPopupMenu->setActiveAction(iActionOpen);
	aPopupMenu->addAction(iActionEdit);
	aPopupMenu->addAction(iActionDelete);
}

void WPBlogGraphicsList::AddNewBlog()
{
    iBlogView->ShowNewBlogView();
}

void WPBlogGraphicsList::Open()
{
    iBlogView->OpenBlog(CurrentBlogId());
#ifdef Q_WS_MAEMO_5
    close();
#endif
}

void WPBlogGraphicsList::Edit()
{
    iBlogView->ShowEditBlogView(CurrentBlogId());
}

void WPBlogGraphicsList::Delete()
{
    WP_CONFIRM_AND_RETURN_ON_FALSE;

    if (iBlogView->DeleteBlog(CurrentBlogId()))
    {
        iDeferredRemoveLayoutItem = iCurrentItem;
        QTimer::singleShot(100, this, SLOT(DeferredRemoveBlogFromLayout));
    }
}

void WPBlogGraphicsList::DeferredRemoveBlogFromLayout()
{
    iListLayout->removeItem(iDeferredRemoveLayoutItem);
    iDeferredRemoveLayoutItem = 0;
}

QString const WPBlogGraphicsList::CurrentBlogId()
	{
    if(CurrentItem())
        return CurrentItem()->getBlog().LocalId();
    else
        return QString();
	}

bool WPBlogGraphicsList::IsFocusable(QGraphicsLayoutItem * item)
{
    QGraphicsItem * gItem = item->graphicsItem();
    return (WPGraphicsList::IsListItem(gItem) || gItem == iNewBlogButton); 
}
