/*
 * themedatastorage.h
 *
 *  Created on: 27.5.2010
 *      Author: jlep
 */

#ifndef THEMEDATASTORAGE_H_
#define THEMEDATASTORAGE_H_

#include <QPixmap>
#include <QIcon>
#include <QMap>

class ThemeData
{
public:
    enum TIconSheet
    {
        EMainWindow = 0,
        EComments = 1,
        EHome = 2,
        ELink = 3,
        EImaging = 4,
        EPages = 5,
        EPower = 6,
        ETools = 7,
        ESwitch = 8,
        EPosts = 9,
        EUsers = 10,
        EKeys = 11
    };
    
    enum TContextIconSheet
    {
        EApprove = 0,
        EEdit = 1,
        EOpen = 2,
        ERemove = 3,
        EReply = 4,
        ESpam = 5,
        EView = 6
    };
    
public:
    ThemeData();
    ~ThemeData();
    void Init();

public:
    
    bool AnimateMenus() const;
    
    // Tabbar
    QBrush*  iTabGradientBrush;
    QFont*   iTabFont;
    int      iTabBarHeight;
    QSizeF   iMinTabSize;

    QPixmap const & GetIcon(TIconSheet icon) { return GetIcon(iIconSheet, iIcons, icon); }
    QPixmap const & GetBwIcon(TIconSheet icon) { return GetIcon(iBwIconSheet, iBwIcons, icon); }
    
    QPixmap const & GetContextIcon(TContextIconSheet icon);
    
    // List stuff
    QFont* iListContentFont; // Main content
    QFont* iListInfoFont;    // Post author, post title of comments, etc.
    
    int    iListItemContentVMargin;
    int    iListItemContentHMargin;
    int    iListItemInternalPadding;
    bool   iListShowCommentIcons;
   
    int    iListTitleMargin; 
    int    iListTitleHeight;
    int    iListItemSpacing;

    
    QString iListButtonQss;
    
private: // Icons
    typedef QMap<TIconSheet, QPixmap> IconMap;
    
    static QPixmap const & GetIcon(QPixmap const & source, IconMap & map, TIconSheet icon);
    
    QPixmap iIconSheet;
    IconMap iIcons;
    
    QPixmap iBwIconSheet;
    IconMap iBwIcons;
    
    typedef QMap<TContextIconSheet, QPixmap> ContextIconMap;
    ContextIconMap iContextIcons;
    
private: // Misc stuff
    static bool AnimateMenusSymbian();
};


#endif //THEMEDATASTORAGE_H_
