/*
 * statsweeklydata.cpp
 *
 *  Created on: 22.3.2010
 *      Author: aahv
 */

#include "statsweeklydata.h"

StatsWeeklyData::StatsWeeklyData() : LinePlotData()
{

}

StatsWeeklyData::~StatsWeeklyData() {

}

void StatsWeeklyData::reload(const QMap<QDate, int> &data, QDate from, QDate to) {
    this->data.clear();

    minValue = 0;
    maxValue = 0;

    from = from.addDays(-1 * (from.dayOfWeek() - 1));
    to = to.addDays(-1 * (to.dayOfWeek() - 1));

    QMap<QDate, int>::const_iterator it = data.lowerBound(from);
    QMap<QDate, int>::const_iterator itEnd = data.upperBound(to.addDays(7));

    int count = 0;
    while (from <= to && it != itEnd) {
        QDate key = it.key().addDays(-1 * (it.key().dayOfWeek() - 1));
        if (key == from) {
            count += it.value();
            it++;
        } else {
            this->data.insert(from, count);

            if (count < minValue)
                minValue = count;
            if (count > maxValue)
                maxValue = count;

            count = 0;
            from = from.addDays(7);
        }
    }

    this->data.insert(to, count);

    if (count < minValue)
        minValue = count;
    if (count > maxValue)
        maxValue = count;
}

int StatsWeeklyData::getDataCount() const {
    return data.size();
}

QVariant StatsWeeklyData::getData(int index) const {
    QDate date = data.keys()[index];
    int year;
    int week = date.weekNumber(&year);
    return QString("%1-%2").arg(year).arg(week, 2, 10, QChar('0'));
}

int StatsWeeklyData::getMinValue() const {
    return minValue;
}

int StatsWeeklyData::getMaxValue() const {
    return maxValue;
}

int StatsWeeklyData::getValue(int index) const {
    return data.values()[index];
}
