/*
 * statsvisits.h
 *
 *  Created on: 19.3.2010
 *      Author: aahv
 */

#ifndef STATSVISITS_H
#define STATSVISITS_H

#include <QWidget>
#include <QStandardItemModel>
#include <QAbstractButton>

#include "WPData.h"
#include "lineplot.h"
#include "lineplotdata.h"
#include "statsdailydata.h"
#include "statsweeklydata.h"
#include "statsmonthlydata.h"

namespace Ui {
    class StatsVisits;
}

class StatsVisits : public QWidget {
    Q_OBJECT
public:
    StatsVisits(QWidget *parent = 0);
    ~StatsVisits();

public slots:
    void updateStats(const WPDataStats& stats);

protected:
    void changeEvent(QEvent *e);

private slots:
    void buttonClicked(QAbstractButton* button);

private:
    void switchPlotData(LinePlotData* data);

private:
    Ui::StatsVisits *ui;
    LinePlot* plot;

    StatsDailyData* dailyData;
    StatsWeeklyData* weeklyData;
    StatsMonthlyData* monthlyData;

};

#endif // STATSVISITS_H
